/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client.rmc;

import com.ibm.hsc.client.rmc.HSCRMCClient;
import com.ibm.hsc.client.rmc.HSCRMCException;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.util.LparCmdRMSessionMgr;
import com.ibm.rsct.rmcjni.McClassActionRsp;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtInt32;
import com.ibm.rsct.util.CtString;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.rsct.util.CuException;
import com.ibm.websm.diagnostics.IDebug;
import java.util.Hashtable;

public class HSCRMCClientImpl
implements HSCRMCClient {
    private static final String DLPAR_BUNDLE_NAME = "DLPARBundle";
    private static final String LPAR_BUNDLE_NAME = "LPARBundle";
    private static final String ERR_DRMGR_CMD_FAILED = "drmgr command failed";
    private static final String ERR_LOCAL_RMC_SYS = "Error in local RMC subsystem";
    protected static final String RMC_RETURN_CODE = "Rc";
    protected static final String RMC_CMD_RETURN_CODE = "CmdRc";
    protected static final String RMC_CMD_STD_OUT = "CmdStdoutMsg";
    protected static final String RMC_CMD_STD_ERR = "CmdStderrMsg";
    protected static final String RMC_CMD_SUCC_NUM = "CmdSuccNum";
    protected static final String RMC_DLPAR_COMMAND = "DLParCommand";
    protected static final String RMC_REMOTE_COMMAND = "RemoteCommand";
    protected static final int CMD_SHUTDOWN_ID = 1;
    protected static final int RMC_ERROR = 2;
    protected static final int AIX_ERROR = 4;
    protected static final String ERROR_CODE = "HMC_ERROR_CODE";
    private static final String ERR_RMC_CMD_EXCEPTION = "HMCERRV3DLPAR003: RMC operation {0} on {1} resource throws exception. The request number is {2}. The success number is {3}";
    private static final String ERR_RMC_CMD_ERROR_NO_OUT = "HMCERRV3DLPAR004: RMC operation {0} on {1} resource failed without throwing exception. The request number is {2}. The success number is {3}. The AIX standard output/error is not available.";
    private static final String ERR_RMC_CMD_ERROR = "HMCERRV3DLPAR005: RMC operation {0} on {1} resource failed without throwing exception. The request number is {2}. The success number is {3}. The AIX standard output is:\n {4}\nThe AIX standard error is:\n{5}";
    private static final String ERR_RMC_AIX_CMD_ERROR = "HMCERRV3DLPAR020: AIX DLPAR operation {0} on {1} resource failed without throwing exception. The request number is {2}. The success number is {3}.\nThe AIX command is:\n{4}\n\nThe AIX standard output is:\n {5}\nThe AIX standard error is:\n{6}";
    private static final String RMC_AIX_RETURN_CODE = "The RMC return code is {0}. The AIX return code is {1}.";
    private String mCECName;
    private String mLPARName;

    public static HSCRMCClientImpl createInstance(String string, String string2) throws HSCException {
        return new HSCRMCClientImpl(string, string2);
    }

    protected HSCRMCClientImpl(String string, String string2) {
        this.mCECName = string;
        this.mLPARName = string2;
    }

    protected HSCRMCException createException(String string, String string2, int n, int n2, Hashtable hashtable, int n3, String string3) {
        Object object;
        String string4 = null;
        if (hashtable == null) {
            string4 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_CMD_ERROR_NO_OUT", ERR_RMC_CMD_ERROR_NO_OUT, new String[]{string, string2, "" + n2, "" + n});
        } else {
            String string5;
            if (string2.equals("mem") && (object = (Integer)hashtable.get(RMC_CMD_SUCC_NUM)) != null) {
                n = (Integer)object;
            }
            if ((object = (String)hashtable.get(RMC_CMD_STD_OUT)) == null || ((String)object).equals("")) {
                object = " ";
            }
            if ((string5 = (String)hashtable.get(RMC_CMD_STD_ERR)) == null || string5.equals("")) {
                string5 = " ";
            }
            string4 = (n3 & 2) != 0 ? HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_CMD_ERROR", ERR_RMC_CMD_ERROR, new String[]{string, string2, "" + n2, "" + n, object, string5}) : HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_AIX_CMD_ERROR", ERR_RMC_AIX_CMD_ERROR, new String[]{string, string2, "" + n2, "" + n, string3, object, string5});
            string4 = string4 + "\n" + hashtable.get(ERROR_CODE);
            hashtable.remove(ERROR_CODE);
        }
        if (IDebug.enabled) {
            System.out.println("command failed without exception");
        }
        object = new HSCRMCException(string4, n);
        ((HSCRMCException)object).setAIXError(n3 == 4);
        if (IDebug.enabled) {
            System.out.println("newExp: " + object);
        }
        return object;
    }

    public int rmcDLPAROp(int n, int n2, short s, String string, String[] stringArray, String string2) throws HSCRMCException {
        String string3 = n2 < 1 ? null : "" + n2;
        Object var8_8 = null;
        int n3 = 0;
        if (string.equals("mem")) {
            this.runRMCCommand(n, string3, string, s, string2, null, n3);
        } else {
            for (int i = 0; i < n; ++i) {
                String string4 = stringArray == null ? null : stringArray[i];
                this.runRMCCommand(n, string3, string, s, string2, string4, n3);
                ++n3;
            }
        }
        return n;
    }

    public Hashtable rmcShutdownOp(boolean bl, boolean bl2) throws HSCException {
        CtStructuredData ctStructuredData = new CtStructuredData(new CtDataType[5]);
        Hashtable<String, Object> hashtable = null;
        String string = this.getRMCShutdownCommand(bl, bl2);
        if (IDebug.enabled) {
            System.out.println("HSCRMCClient.rmcShutdownOp() - command arguments = " + string);
        }
        try {
            ctStructuredData.setData(0, (CtDataType)new CtString(this.mCECName.substring(0, this.mCECName.indexOf(42))));
            ctStructuredData.setData(1, (CtDataType)new CtString(this.mCECName.substring(this.mCECName.indexOf(42) + 1)));
            ctStructuredData.setData(2, (CtDataType)new CtString(this.mLPARName.substring(0, 3)));
            ctStructuredData.setData(3, (CtDataType)new CtInt32(1));
            ctStructuredData.setData(4, (CtDataType)new CtString(string));
            McClassActionRsp[] mcClassActionRspArray = LparCmdRMSessionMgr.getLparCmdRMSession().invokeAction(RMC_REMOTE_COMMAND, null, ctStructuredData);
            if (mcClassActionRspArray != null) {
                CtStructuredData[] ctStructuredDataArray = mcClassActionRspArray[0].getData();
                if (ctStructuredDataArray != null) {
                    CtStructuredData ctStructuredData2 = ctStructuredDataArray[0];
                    if (IDebug.enabled) {
                        if (ctStructuredData2 != null) {
                            System.out.println("HSCRMCClient.rmcShutdownOp() - outParams element count = " + ctStructuredData2.getElementCount());
                        } else {
                            System.out.println("HSCRMCClient.rmcShutdownOp() - outParams is null");
                        }
                    }
                    if (ctStructuredData2 != null && ctStructuredData2.getElementCount() > 1) {
                        hashtable = new Hashtable<String, Object>();
                        hashtable.put(RMC_RETURN_CODE, new Integer(((CtInt32)ctStructuredData2.getData(0)).getData()));
                        hashtable.put(RMC_CMD_RETURN_CODE, new Integer(((CtInt32)ctStructuredData2.getData(1)).getData()));
                        hashtable.put("CmdRetMsg", ((CtString)ctStructuredData2.getData(2)).getData());
                    }
                } else if (mcClassActionRspArray[0].hasError()) {
                    throw new CuException(mcClassActionRspArray[0].getErrorMessage());
                }
            }
        }
        catch (Exception exception) {
            if (IDebug.enabled) {
                exception.printStackTrace(System.out);
            }
            LparCmdRMSessionMgr.invalidateLparCmdRMSession();
            throw new HSCException(exception);
        }
        return hashtable;
    }

    private void runRMCCommand(int n, String string, String string2, short s, String string3, String string4, int n2) throws HSCRMCException {
        Hashtable hashtable = null;
        String string5 = this.getRMCCommand(string, string4, string3, string2, s, n);
        try {
            hashtable = this.rmcDLPARCommand(string5, s);
        }
        catch (Throwable throwable) {
            throw new HSCRMCException(HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_CMD_EXCEPTION", ERR_RMC_CMD_EXCEPTION, new String[]{string3, string2, "" + n, "" + n2}), throwable, n2);
        }
        int n3 = this.prtDLPARCmdOut(hashtable);
        if (IDebug.enabled) {
            System.out.println("rtn: " + n3);
        }
        if (n3 == 0) {
            if (string2.equals("mem")) {
                Integer n4 = (Integer)hashtable.get(RMC_CMD_SUCC_NUM);
                n2 = n4 == null ? 0 : n4;
                if (n2 == n) {
                    return;
                }
            } else {
                return;
            }
        }
        throw this.createException(string3, string2, n2, n, hashtable, n3, string5);
    }

    private Hashtable rmcDLPARCommand(String string, short n) throws HSCException {
        int n2 = 0;
        CtStructuredData ctStructuredData = new CtStructuredData(new CtDataType[5]);
        Hashtable<String, Object> hashtable = null;
        if (IDebug.enabled) {
            System.out.println("rmc command: " + string);
        }
        if (n != -1 && n <= 5) {
            n2 = n;
        }
        if (n == 99) {
            n2 = 99;
        }
        try {
            ctStructuredData.setData(0, (CtDataType)new CtString(this.mCECName.substring(0, this.mCECName.indexOf(42))));
            ctStructuredData.setData(1, (CtDataType)new CtString(this.mCECName.substring(this.mCECName.indexOf(42) + 1)));
            String string2 = this.mLPARName.substring(0, this.mLPARName.indexOf(42));
            ctStructuredData.setData(2, (CtDataType)new CtString(string2));
            ctStructuredData.setData(3, (CtDataType)new CtString(string));
            ctStructuredData.setData(4, (CtDataType)new CtInt32(n2));
            McClassActionRsp[] mcClassActionRspArray = LparCmdRMSessionMgr.getLparCmdRMSession().invokeAction(RMC_DLPAR_COMMAND, null, ctStructuredData);
            if (mcClassActionRspArray != null) {
                CtStructuredData[] ctStructuredDataArray = mcClassActionRspArray[0].getData();
                if (ctStructuredDataArray != null) {
                    CtStructuredData ctStructuredData2 = ctStructuredDataArray[0];
                    if (IDebug.enabled) {
                        if (ctStructuredData2 != null) {
                            System.out.println("return elm count: " + ctStructuredData2.getElementCount());
                        } else {
                            System.out.println("outParams is null");
                        }
                    }
                    if (ctStructuredData2 != null && ctStructuredData2.getElementCount() > 1) {
                        hashtable = new Hashtable<String, Object>();
                        hashtable.put(RMC_RETURN_CODE, new Integer(((CtInt32)ctStructuredData2.getData(0)).getData()));
                        hashtable.put(RMC_CMD_RETURN_CODE, new Integer(((CtInt32)ctStructuredData2.getData(1)).getData()));
                        if (ctStructuredData2.getElementCount() > 2) {
                            hashtable.put(RMC_CMD_STD_OUT, ((CtString)ctStructuredData2.getData(2)).getData());
                        }
                        if (ctStructuredData2.getElementCount() > 3) {
                            hashtable.put(RMC_CMD_STD_ERR, ((CtString)ctStructuredData2.getData(3)).getData());
                        }
                        if (ctStructuredData2.getElementCount() > 4) {
                            hashtable.put(RMC_CMD_SUCC_NUM, new Integer(((CtInt32)ctStructuredData2.getData(4)).getData()));
                            if (IDebug.enabled) {
                                System.out.println("succ_num is: " + (Integer)hashtable.get(RMC_CMD_SUCC_NUM));
                            }
                        }
                    }
                } else if (mcClassActionRspArray[0].hasError()) {
                    throw new CuException(mcClassActionRspArray[0].getErrorMessage());
                }
            }
        }
        catch (Exception exception) {
            if (IDebug.enabled) {
                exception.printStackTrace(System.out);
            }
            LparCmdRMSessionMgr.invalidateLparCmdRMSession();
            throw new HSCException(exception);
        }
        return hashtable;
    }

    private int prtDLPARCmdOut(Hashtable hashtable) {
        int n = 0;
        if (hashtable == null) {
            if (IDebug.enabled) {
                System.out.println(HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "DLPAR_COMMAND_FAILED", ERR_LOCAL_RMC_SYS));
            }
            ++n;
        } else {
            Object v;
            Object v2;
            if (IDebug.enabled) {
                System.out.println(hashtable.get(RMC_CMD_STD_OUT));
                System.out.println(hashtable.get(RMC_CMD_STD_ERR));
            }
            if ((v2 = hashtable.get(RMC_RETURN_CODE)) == null || (Integer)v2 != 0) {
                if (IDebug.enabled) {
                    System.out.println(HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "DLPAR_COMMAND_FAILED", ERR_LOCAL_RMC_SYS));
                    System.out.println("RMC_RETURN_CODE: " + (Integer)v2);
                }
                n += 2;
            }
            if ((v = hashtable.get(RMC_CMD_RETURN_CODE)) == null || (Integer)v != 0) {
                if (IDebug.enabled) {
                    System.out.println(HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "DRMGR_FAILED", ERR_DRMGR_CMD_FAILED));
                    System.out.println("RMC_CMD_RETURN_CODE: " + (Integer)v);
                }
                n += 4;
            }
            String string = HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "RMC_AIX_RETURN_CODE", RMC_AIX_RETURN_CODE, new String[]{"" + v2, "" + v});
            hashtable.put(ERROR_CODE, string);
        }
        return n;
    }

    private String getRMCCommand(String string, String string2, String string3, String string4, short s, int n) {
        return "drmgr -" + string3 + " -c " + string4 + (string2 == null ? "" : " -s " + string2) + (string4.equals("mem") || string4.equals("cpu") ? " -q " + n : "") + (string == null ? "" : " -w " + string) + (s < 0 ? "" : " -d " + s);
    }

    private String getRMCShutdownCommand(boolean bl, boolean bl2) {
        return " " + (bl2 ? "-F " : "") + (bl ? "-r " : "");
    }
}

